<?= $this->extend('layouts/auth') ?>

<?= $this->section('content') ?>
<div class="container d-flex align-items-center justify-content-center min-vh-100">
    <div class="row w-100 justify-content-center">
        <div class="col-lg-8 col-xl-6">
            <div class="card shadow-lg border-0" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); border-radius: 20px;">
                <div class="card-body p-4">
                    <!-- Header -->
                    <div class="text-center mb-4">
                        <div class="d-inline-flex align-items-center justify-content-center bg-primary rounded-circle mb-3" style="width: 60px; height: 60px;">
                            <i class="bi bi-shield-lock text-white" style="font-size: 1.5rem;"></i>
                        </div>
                        <h2 class="text-primary fw-bold mb-2">Pilih Admin Login</h2>
                        <p class="text-muted mb-0">Silakan pilih jenis admin untuk login</p>
                    </div>

                    <!-- Alert Messages -->
                    <?php if (session()->getFlashdata('error')): ?>
                        <div class="alert alert-danger d-flex align-items-center mb-4" role="alert">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <?= session()->getFlashdata('error') ?>
                        </div>
                    <?php endif; ?>

                    <!-- Role Selection Grid -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-4">
                            <a href="<?= base_url('auth/login/admin_activities') ?>" class="text-decoration-none">
                                <div class="card h-100 border-primary" style="transition: all 0.3s ease; cursor: pointer;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 10px 30px rgba(65, 105, 225, 0.3)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(65, 105, 225, 0.1)';">
                                    <div class="card-body text-center p-3">
                                        <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 50px; height: 50px;">
                                            <i class="bi bi-calendar-event text-white" style="font-size: 1.2rem;"></i>
                                        </div>
                                        <h6 class="text-primary fw-bold mb-2">Admin Aktivitas</h6>
                                        <p class="text-muted small mb-0">Kelola aktivitas harian</p>
                                    </div>
                                </div>
                            </a>
                        </div>

                        <div class="col-md-4">
                            <a href="<?= base_url('auth/login/admin_biodata') ?>" class="text-decoration-none">
                                <div class="card h-100 border-primary" style="transition: all 0.3s ease; cursor: pointer;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 10px 30px rgba(65, 105, 225, 0.3)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(65, 105, 225, 0.1)';">
                                    <div class="card-body text-center p-3">
                                        <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 50px; height: 50px;">
                                            <i class="bi bi-person text-white" style="font-size: 1.2rem;"></i>
                                        </div>
                                        <h6 class="text-primary fw-bold mb-2">Admin Biodata</h6>
                                        <p class="text-muted small mb-0">Kelola CV & portfolio</p>
                                    </div>
                                </div>
                            </a>
                        </div>

                        <div class="col-md-4">
                            <a href="<?= base_url('auth/login/admin_education') ?>" class="text-decoration-none">
                                <div class="card h-100 border-primary" style="transition: all 0.3s ease; cursor: pointer;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 10px 30px rgba(65, 105, 225, 0.3)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(65, 105, 225, 0.1)';">
                                    <div class="card-body text-center p-3">
                                        <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 50px; height: 50px;">
                                            <i class="bi bi-mortarboard text-white" style="font-size: 1.2rem;"></i>
                                        </div>
                                        <h6 class="text-primary fw-bold mb-2">Admin Pendidikan</h6>
                                        <p class="text-muted small mb-0">Kelola riwayat pendidikan</p>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="text-center">
                        <a href="<?= base_url() ?>" class="btn btn-outline-primary">
                            <i class="bi bi-arrow-left me-1"></i>Kembali ke Beranda
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>


